<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\VMMigrationService;

class ImageImportOsAdaptationParameters extends \Google\Model
{
  /**
   * @var string
   */
  public $bootConversion;
  /**
   * @var bool
   */
  public $generalize;
  /**
   * @var string
   */
  public $licenseType;

  /**
   * @param string
   */
  public function setBootConversion($bootConversion)
  {
    $this->bootConversion = $bootConversion;
  }
  /**
   * @return string
   */
  public function getBootConversion()
  {
    return $this->bootConversion;
  }
  /**
   * @param bool
   */
  public function setGeneralize($generalize)
  {
    $this->generalize = $generalize;
  }
  /**
   * @return bool
   */
  public function getGeneralize()
  {
    return $this->generalize;
  }
  /**
   * @param string
   */
  public function setLicenseType($licenseType)
  {
    $this->licenseType = $licenseType;
  }
  /**
   * @return string
   */
  public function getLicenseType()
  {
    return $this->licenseType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ImageImportOsAdaptationParameters::class, 'Google_Service_VMMigrationService_ImageImportOsAdaptationParameters');
