import {SiteConfigContextValue} from '@common/core/settings/site-config-context';
import {CommonUploadType} from '@common/uploads/common-upload-type';
import {message} from '@ui/i18n/message';

export const SiteConfig: Partial<SiteConfigContextValue> = {
  auth: {
    redirectUri: '/',
    secondaryRedirectUri: '/hc',
    adminRedirectUri: '/admin',
  },
  homepage: {
    options: [
      {
        label: message('Landing page'),
        value: 'landingPage',
      },
    ],
  },
  roles: {
    types: [
      {
        type: 'users',
        label: message('Customers'),
      },
      {
        type: 'agents',
        label: message('Agents'),
        permission_type: 'users',
      },
    ],
  },
  demo: {
    loginPageDefaults: 'singleAccount',
  },
  settings: {
    showIncomingMailMethod: true,
  },
};

export const UploadType = {
  ...CommonUploadType,
} as const;
