import {FullConversationResponse} from '@app/dashboard/conversation';
import {ConversationCategoryAttribute} from '@app/attributes/compact-attribute';
import {EnvatoPurchaseList} from '@envato/envato-purchase-list/envato-purchase-list';
import {PersonIcon} from '@ui/icons/material/Person';
import {Fragment, useMemo} from 'react';

interface Props {
  data: FullConversationResponse;
}
export function ConversationPagePurchaseList({data}: Props) {
  const categoryAttribute = data.attributes.find(
    attribute => attribute.key === 'category',
  ) as ConversationCategoryAttribute | undefined;
  const currentPurchase = useMemo(() => {
    return (
      data.envatoPurchaseCodes.find(code =>
        categoryAttribute?.config?.options?.find(option =>
          option.envatoItems?.includes(code.item_id),
        ),
      ) || data.envatoPurchaseCodes[0]
    );
  }, [data, categoryAttribute?.config?.options]);

  return (
    <Fragment>
      {currentPurchase && (
        <div className="mb-8 flex items-center gap-4 text-sm">
          <PersonIcon size="sm" />
          <a
            href={`https://codecanyon.net/user/${currentPurchase.envato_username}`}
            target="_blank"
            rel="noreferrer"
          >
            {currentPurchase.envato_username}
          </a>
        </div>
      )}
      <EnvatoPurchaseList
        userId={data.user.id}
        initialData={data.envatoPurchaseCodes}
        selectedPurchaseId={currentPurchase?.id}
      />
    </Fragment>
  );
}
