<?php

namespace Common\Files\Middleware;

use Common\Files\Actions\GetUserSpaceUsage;
use Common\Files\Actions\FileUploadValidator;
use Common\Files\FileEntry;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;

class DefaultFileUploadMiddleware implements FileUploadMiddlewareContract
{
    public function validate(array $data): Collection|null
    {
        $spaceUsage = Auth::check() ? new GetUserSpaceUsage() : null;

        return (new FileUploadValidator(
            allowedExtensions: settings('uploads.allowed_extensions'),
            blockedExtensions: settings('uploads.blocked_extensions'),
            maxFileSize: settings('uploads.max_size'),
            usedSpace: $spaceUsage?->getSpaceUsed(),
            availableSpace: $spaceUsage?->getAvailableSpace(),
        ))->validate(
            fileSize: Arr::get($data, 'size'),
            extension: Arr::get($data, 'extension'),
            mime: Arr::get($data, 'mime'),
        );
    }

    public function handle(FileEntry $fileEntry, array $data): FileEntry
    {
        return $fileEntry;
    }
}
