import {Component as CustomPageLayout} from '@common/custom-page/custom-page-layout';
import {useSettings} from '@ui/settings/use-settings';
import {ReactElement} from 'react';
import {Navigate} from 'react-router';

interface DynamicHomepageProps {
  homepageResolver?: (type?: string) => ReactElement;
}
export function DynamicHomepage({homepageResolver}: DynamicHomepageProps) {
  const {homepage} = useSettings();

  if (homepage?.type === 'loginPage') {
    return <Navigate to="/login" />;
  }

  if (homepage?.type === 'registerPage') {
    return <Navigate to="/register" />;
  }

  if (homepage?.type === 'customPage') {
    return <CustomPageLayout slug={homepage.value} />;
  }

  return homepageResolver?.(homepage?.type) || null;
}
