<?php

return [
    // laravel
    'disks' => [
        'local' => [
            'driver' => 'local',
            'root' => public_path('storage'),
            'throw' => true,
        ],

        'uploads' => [
            'driver' => 'dynamic-uploads',
            'local_root' => env(
                'PRIVATE_UPLOADS_LOCAL_ROOT',
                storage_path('app/uploads'),
            ),
            'remote_root' => env('PRIVATE_UPLOADS_REMOTE_ROOT', 'uploads'),
        ],

        'public' => [
            'driver' => 'dynamic-public',
            'url' => 'storage',
            'visibility' => 'public',
            'throw' => true,
            'local_root' => env(
                'PUBLIC_UPLOADS_LOCAL_ROOT',
                public_path('storage'),
            ),
            'remote_root' => env('PUBLIC_UPLOADS_REMOTE_ROOT', 'storage'),
        ],
    ],

    // app
    'remote_file_visibility' => env('REMOTE_FILE_VISIBILITY', 'private'),
    'disable_thumbnail_creation' => env('DISABLE_THUMBNAIL_CREATION', false),
    'use_presigned_s3_urls' => env('USE_PRESIGNED_S3_URLS', true),
    'static_file_delivery' => env('STATIC_FILE_DELIVERY', null),
    'uploads_disk_driver' => env('UPLOADS_DISK_DRIVER', 'local'),
    'public_disk_driver' => env('PUBLIC_DISK_DRIVER', 'local'),
    'file_preview_endpoint' => env('FILE_PREVIEW_ENDPOINT'),
    'uploads_disable_tus' => env('UPLOADS_DISABLE_TUS'),
    'uploads_tus_method' => env('UPLOADS_TUS_METHOD'),
];
