<?php

namespace App\HelpCenter\Actions;

use Illuminate\Support\Str;
use Symfony\Component\DomCrawler\Crawler;

class ReplaceArticleBodyUrls
{
    public function replaceImgSrc(
        string $body,
        array $oldBaseUris,
        string|null $newBaseUri = null,
    ): string {
        $oldBaseUris[] = 'http://localhost:4200';
        return $this->replace('img', 'src', $body, $oldBaseUris, $newBaseUri);
    }

    public function replaceLinkHref(
        string $body,
        array $oldBaseUris,
        string|null $newBaseUri = null,
    ): string {
        return $this->replace('a', 'href', $body, $oldBaseUris, $newBaseUri);
    }

    protected function replace(
        string $tagName,
        string $attributeName,
        string $body,
        array $oldBaseUris,
        string|null $newBaseUri = null,
    ) {
        $crawler = new Crawler();
        $crawler->addHtmlContent($body);
        $newBaseUri = $newBaseUri ?: config('app.url');

        $crawler
            ->filter($tagName)
            ->each(function (Crawler $node) use (
                $oldBaseUris,
                $newBaseUri,
                $attributeName,
            ) {
                $oldSrc = $node->attr($attributeName);
                $oldBaseUris[] = 'http://localhost:4200';

                if (Str::contains($oldSrc, $oldBaseUris)) {
                    $newSrc = str_replace($oldBaseUris, $newBaseUri, $oldSrc);
                    $node->getNode(0)->setAttribute($attributeName, $newSrc);
                }
            });

        return $crawler->filter('body')->html();
    }
}
