<?php

namespace App\Demo;

use Common\Files\FileEntry;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class CreateDemoAttachments
{
    public function execute()
    {
        $data = [
            [
                'name' => 'image-1.jpg',
                'file_name' => 'image-1.jpg',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'image/jpeg',
                'extension' => 'jpg',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'image',
            ],
            [
                'name' => 'doc-1.xls',
                'file_name' => 'doc-1.xls',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'application/vnd.ms-excel',
                'extension' => 'xls',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'spreadsheet',
            ],
            [
                'name' => 'audio-1.mp3',
                'file_name' => 'audio-1.mp3',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'audio/mpeg',
                'extension' => 'mp3',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'audio',
            ],
            [
                'name' => 'image-2.jpg',
                'file_name' => 'image-2.jpg',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'image/jpeg',
                'extension' => 'jpg',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'image',
            ],
            [
                'name' => 'doc-2.pptx',
                'file_name' => 'doc-2.pptx',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' =>
                    'application/vnd.openxmlformats-officedocument.presentationml.presentation',
                'extension' => 'pptx',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'powerPoint',
            ],
            [
                'name' => 'video-1.mp4',
                'file_name' => 'video-1.mp4',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'video/mp4',
                'extension' => 'mp4',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'video',
            ],
            [
                'name' => 'image-3.jpg',
                'file_name' => 'image-3.jpg',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'image/jpeg',
                'extension' => 'jpg',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'image',
            ],
            [
                'name' => 'doc-3.doc',
                'file_name' => 'doc-3.doc',
                'disk_prefix' => 'demo-files',
                'file_size' => rand(200000, 2000000),
                'mime' => 'application/msword',
                'extension' => 'doc',
                'created_at' => now(),
                'updated_at' => now(),
                'public' => true,
                'type' => 'word',
            ],
        ];

        foreach ($data as $item) {
            $localPath =
                public_path('/') .
                $item['disk_prefix'] .
                '/' .
                $item['file_name'];
            $storagePath = $item['disk_prefix'] . '/' . $item['file_name'];

            Storage::disk('public')->put(
                $storagePath,
                file_get_contents($localPath),
            );
        }

        FileEntry::insert($data);
    }
}
