<?php

namespace App\Core;

use Ai\AiServiceProvider;
use Envato\EnvatoServiceProvider;
use Illuminate\Foundation\Application;
use Livechat\LiveChatServiceProvider;

class Modules
{
    public static array $all = [
        'envato' => [
            'namespace' => EnvatoServiceProvider::class,
            'installed' => false,
            'setup' => false,
        ],
        'livechat' => [
            'namespace' => LiveChatServiceProvider::class,
            'installed' => false,
            'setup' => false,
        ],
        'ai' => [
            'namespace' => AiServiceProvider::class,
            'installed' => false,
            'setup' => false,
        ],
    ];

    public static function livechatInstalled(): bool
    {
        return static::$all['livechat']['installed'];
    }

    public static function aiInstalled(): bool
    {
        return static::$all['ai']['installed'];
    }

    public static function envatoInstalled(): bool
    {
        return static::$all['envato']['installed'];
    }

    public static function register(Application $app): void
    {
        if (static::safeClassExists(EnvatoServiceProvider::class)) {
            static::$all['envato'] = [
                'namespace' => EnvatoServiceProvider::class,
                'installed' => true,
                'setup' =>
                    config('services.envato.client_id') &&
                    config('services.envato.client_secret') &&
                    config('services.envato.personal_token'),
            ];
            (new EnvatoServiceProvider($app))->register();
        }

        if (static::safeClassExists(LiveChatServiceProvider::class)) {
            static::$all['livechat'] = [
                'namespace' => LiveChatServiceProvider::class,
                'installed' => true,
                'setup' => true,
            ];
            (new LiveChatServiceProvider($app))->register();
        }

        if (static::safeClassExists(AiServiceProvider::class)) {
            static::$all['ai'] = [
                'namespace' => AiServiceProvider::class,
                'installed' => true,
            ];
            (new AiServiceProvider($app))->register();
        }
    }

    public static function boot(Application $app): void
    {
        if (static::safeClassExists(EnvatoServiceProvider::class)) {
            (new EnvatoServiceProvider($app))->boot();
            static::$all['envato']['setup'] = settings('envato.enable');
        }

        if (static::safeClassExists(LiveChatServiceProvider::class)) {
            (new LiveChatServiceProvider($app))->boot();
        }

        if (static::safeClassExists(AiServiceProvider::class)) {
            (new AiServiceProvider($app))->boot();
            static::$all['ai']['setup'] = !!config('services.openai.api_key');
        }
    }

    protected static function safeClassExists(string $className): bool
    {
        try {
            return class_exists($className);
        } catch (\Throwable $e) {
            return false;
        }
    }
}
